% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarymodid.R
\name{summary.modid}
\alias{summary.modid}
\title{Summary Function for S3 Objects of Class \code{modid}}
\usage{
\method{summary}{modid}(object, ..., digits = 4)
}
\arguments{
\item{object}{S3 object of class \code{modid}.}

\item{...}{Additional arguments.}

\item{digits}{The number of digits shown per estimate. The default is \code{digits = 4}.}
}
\value{
Model identification items (one less than the number of factors), factor loadings and absolute sum score for items, and squared factor loadings for the model identification items.
}
\description{
The \code{summary.modid()} function returns the output from the \code{\link[=modid]{modid()}} function.
}
\examples{
\dontrun{
# Identify the DMIRT model using a three-factor EFA with modid()
# x can be a data frame with item data or item factor loadings.
# In the case of the latter, set argument 'efa' to 'FALSE'
g <- modid(x)

# Call to summary
summary(x)

# Call to summary rounded off to 2 digits
summary(x, digits = 2)
}
}
\author{
Erik Forsberg
}
