% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wasser.R
\name{wasserMetric}
\alias{wasserMetric}
\title{Computing Wasserstein Metric}
\usage{
wasserMetric(cases, control, paranum = 101, q = 2)
}
\arguments{
\item{cases}{name of case group data (matrix sample * feature).}

\item{control}{names of control group data (matrix sample * feature).}

\item{paranum}{the number of quatile discretization + 1. Default is discretized by 1\%.}

\item{q}{power of Wasserstein metric. Default is q = 2.}
}
\value{
vector of Wasserstein metric
}
\description{
Computing Wasserstein Metric
}
\examples{
nrep <- 12
cases <- Map(rbeta,rep(50,nrep),rep(1,nrep),rep(5,nrep))
cases <- do.call("rbind",cases)
control <- Map(rbeta,rep(50,nrep),rep(1,nrep),rep(5,nrep))
control <- do.call("rbind",control)
wasserMetric(cases,control)
}
\author{
Yusuke Matsui & Teppei Shimamura
}

