% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.VotingStrategy.R
\name{VotingStrategy}
\alias{VotingStrategy}
\title{Voting Strategy template.}
\description{
Abstract class used to define new \code{\link{SingleVoting}} and
\code{\link{CombinedVoting}} schemes.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{SingleVoting}},
\code{\link{CombinedVoting}}
}
\keyword{math}
\keyword{methods}
\keyword{models}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{VotingStrategy$new()}}
\item \href{#method-getVotingSchemes}{\code{VotingStrategy$getVotingSchemes()}}
\item \href{#method-getMetrics}{\code{VotingStrategy$getMetrics()}}
\item \href{#method-execute}{\code{VotingStrategy$execute()}}
\item \href{#method-getName}{\code{VotingStrategy$getName()}}
\item \href{#method-clone}{\code{VotingStrategy$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Abstract method used to initialize the object arguments
during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VotingStrategy$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getVotingSchemes"></a>}}
\if{latex}{\out{\hypertarget{method-getVotingSchemes}{}}}
\subsection{Method \code{getVotingSchemes()}}{
The function returns the voting schemes that will
participate in the voting strategy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VotingStrategy$getVotingSchemes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector of object inheriting from \code{\link{VotingStrategy}}
class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-getMetrics}{}}}
\subsection{Method \code{getMetrics()}}{
The function is used to get the metric that will be used
during the voting strategy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VotingStrategy$getMetrics()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute"></a>}}
\if{latex}{\out{\hypertarget{method-execute}{}}}
\subsection{Method \code{execute()}}{
Abstract function used to implement the operation of the
voting schemes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VotingStrategy$execute(predictions, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictions}}{A \code{\link{ClusterPredictions}} object containing
the prediction achieved for each cluster.}

\item{\code{...}}{Further arguments passed down to \code{execute} function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getName"></a>}}
\if{latex}{\out{\hypertarget{method-getName}{}}}
\subsection{Method \code{getName()}}{
The function returns the name of the voting scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VotingStrategy$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VotingStrategy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
