#'In this example we show how we train and use our D2C algorithm.
#'This can take some minutes. Please wait
#'@name example_prediction
#'@references Gianluca Bontempi, Maxime Flauder (2014) From dependency to causality: a machine learning approach. Under submission
#'@examples
#'generateRandomForest = TRUE # if true it can takes long time
#'require(D2C)
#'require(RBGL)
#'require(gRbase)
#'H_Rn <- function(n)
#'{
#'  a = runif(n+1,min = -1,max = 1)
#'  f <- function(x)
#'  {
#'    X  = x^(0:n)
#'    return ( sum(X * a))
#'  }
#'  return(Vectorize(f)) 
#'}
#'
#'
#'
#'H_sigmoid <- function(n=2)
#'{
#'  a = runif(n+1,min = -5,max = 5)
#'  f <- function(x)
#'  {
#'    X  = x^(0:n)
#'    return ( 1/(1+exp(sum(X * a))))
#'  }
#'  return(Vectorize(f))
#'}
#'
#'
#'
#'generateTrain <- function(V,wgt,maxpar,H,lin,
#'                          N=sample(100:500,size=1),nConnected = 4,nDisonnected = 4)
#'{ 
#'  bool = TRUE
#'  while(bool)
#'  {
#'   dagTemp = random_dag(V,maxpar = maxpar,wgt)
#'   if (length(edgeList(dagTemp)) > nConnected )
#'   {
#'    bool = FALSE
#'   }
#'  }
#'  DAG = new("D2C.network",network=dagTemp,H=H)
#'  X = compute(DAG,N=N)
#'  DATA = new("D2C.Data",network=DAG@@network,data=X,functionDescriptor=descriptor,lin=lin)
#'  return(list(Y=DATA@@labelEdge,X=DATA@@X_descriptor))
#'  #return(list(Y=DATA@@labelEdge,X=computeDescriptor(DATA,descriptor,lin=lin)))
#'}
#'
#'generateTest <- function(V,wgt,maxpar,H,lin,N=sample(100:500,size=1))
#'{
#'  DAG = new("D2C.network",network=random_dag(V,maxpar = maxpar,wgt),H=H)
#'  X = compute(DAG,N=N)
#'  DATA =new("D2C.Data",network=DAG@@network,data=X,functionDescriptor=descriptor,lin=lin)
#'  return(list(DATA=DATA))
#'}
#'
#'
#'train<-function(NDAG,networkType,functionType,nConnected = 4,nDisonnected = 4)
#'{
#'  #generate a training set 
#'  # NDAG the number of network to use 
#'  #functionType example : "R1" "R2" "sigmoid1"
#'  
#'  
#'  
#'  X=NULL
#'  Y=NULL
#'  for(i in 1:NDAG)
#'  {
#'    cat("DAG number:",i,"generated","\n")
#'    networkParam = generateParamNetwork(type=networkType)
#'    functionParam = generateParamFunction(type=functionType)
#'    V=networkParam$V ; wgt=networkParam$wgt ; maxpar=networkParam$maxpar 
#'    H=functionParam$H ; lin=functionParam$lin
#'    temp=generateTrain(V=V,wgt=wgt,maxpar=maxpar,H=H,lin=lin,nConnected = 4,nDisonnected = 4)
#'    X=rbind(X,temp$X)
#'    Y=c(Y,temp$Y)
#'  }
#' return(list(X=X,Y=Y))
#'}
#'
#'
#' test<-function(NDAG,networkType,functionType)
#'{
#'  #generate a test set
#'  # NDAG the number of network to use
#'  #functionType example : "R1" "R2" "sigmoid1"
#'  
#'  
#'  DATAs = list()
#'  for(i in 1:NDAG)
#'  {
#'    networkParam = generateParamNetwork(type=networkType)
#'    functionParam = generateParamFunction(type=functionType)
#'    V=networkParam$V ; wgt=networkParam$wgt ; maxpar=networkParam$maxpar 
#'    H=functionParam$H ; lin=functionParam$lin
#'    temp=generateTest(V=V,wgt=wgt,maxpar=maxpar,H=H,lin=lin)
#'    DATAs[[i]] = temp$DATA
#'  }
#'  return(DATAs)
#'}
#'
#'
#'
#'
#'generateParamNetwork <- function(type)
#'{
#'  if( type=="large")
#'  {
#'    V=1:sample(500:1000,size=1) ;
#'    wgt = runif(n = 1,min = 0.65,max = 0.85)
#'    maxpar = sample(4:8,size=1)
#'    return(list(V=V,wgt=wgt,maxpar=maxpar))
#'  }
#'  if(type=="medium")
#'  {
#'    V=1:sample(100:200,size=1) ;
#'    wgt = runif(n = 1,min = 0.65,max = 0.85)
#'    maxpar = sample(4:8,size=1)
#'    return(list(V=V,wgt=wgt,maxpar=maxpar))
#'  }
#'  if (type=="small")
#'  {
#'    V=1:sample(20:30,size=1) ;
#'    wgt = runif(n = 1,min = 0.75,max = 0.85)
#'    maxpar = sample(2:6,size=1)
#'    return(list(V=V,wgt=wgt,maxpar=maxpar))
#'  }
#'}
#'
#'
#' 
#'generateParamFunction <- function(type)
#'{
#'   if (type=="linear")
#'  {
#'    return(list(H = function() return(H_Rn(1)),lin=TRUE))
#'  }
#'  if (type=="quadratic")
#'  {
#'    return(list(H = function() return(H_Rn(2)),lin=FALSE))
#'  }
#'  if (type=="sigmoid")
#' {
#'     return(list(H = function() return(H_sigmoid(1)),lin=FALSE))
#'  }
#'  
#'}
#'
#'
#'
#'
#'###here we create a test set 
#'require(D2C)
#'require(randomForest)'
#'networkType = "small"
#'functionType = "linear"
#' NDAG = 1 #increse this number if you want to have good performance (more than 500)
#' DataTrain = train(NDAG=NDAG,networkType=networkType,
#'                  functionType=functionType,nConnected = 4,nDisonnected = 4)
#' Xtrain = DataTrain$X ; Ytrain = DataTrain$Y
#' RF <- randomForest(x =Xtrain ,y = factor(Ytrain))
#'
#'
#'
#'
#'
#'##here we generate a test set
#'
#'networkType = "small"
#'functionType = "linear"
#'Datatest <- test(NDAG=1,networkType,functionType)[[1]]
#'
#'#we predict the whole network 
#'
#'temp.d2cpredict = new("D2C.Predict",data=Datatest@@data,lin=TRUE)
#'Nodes<- nodes(object = Datatest@@network)
#'Nnodes <- length(Nodes)
#'graphPrediction <- matrix(0,ncol=Nnodes,nrow=Nnodes) #the predicted label of the network
#'graphProb <- matrix(0,ncol=Nnodes,nrow=Nnodes) #the probability of two nodes being connected
#'graphTRUE<- as.adjMAT(Datatest@@network) #contrains the true labels of the network
#'colnames(graphPrediction) <-Nodes ; rownames(graphPrediction) <-Nodes
#'graphProb  = graphPrediction
#'for(i in Nodes)
#'{
#'  for(j in setdiff(Nodes,i))
#'  {
#'    temp = predict(temp.d2cpredict,i,j,networkType=networkType,functionType=functionType,RF =RF)
#'    graphPrediction[i,j] <- as.numeric(temp$response)  -1
#'    graphProb[i,j] <-temp$prob[,2]
#'    cat("i=",i,"j=",j,"prediction=",graphPrediction[i,j],"real:",graphTRUE[i,j],"\n")
#'  }
#'}
#'confusionMatrix <- table(graphTRUE,graphPrediction)
NULL