% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossValidationControl.R
\name{createAutoGridCrossValidationControl}
\alias{createAutoGridCrossValidationControl}
\title{Create a Cyclops control object that supports multiple hyperparameters}
\usage{
createAutoGridCrossValidationControl(outerGrid, autoPosition = 1,
  refitAtMaximum = TRUE, cvType = "auto", initialValue = 1, ...)
}
\arguments{
\item{outerGrid}{List or data.frame of grid parameters to explore}

\item{autoPosition}{Vector position for auto-search parameter (concatenated into outerGrid)}

\item{refitAtMaximum}{Logical: re-fit Cyclops object at maximal cross-validation parameters}

\item{cvType}{Must equal "auto"}

\item{initialValue}{Initial value for auto-search parameter}

\item{...}{Additional parameters passed through to \code{\link{createControl}}}
}
\value{
A Cyclops prior object of class inheriting from \code{"cyclopsPrior"} and \code{"cyclopsFunctionalPrior"}
for use with \code{fitCyclopsModel}.
}
\description{
\code{createCrossValidationControl} creates a Cyclops control object for use with \code{\link{fitCyclopsModel}}
that supports multiple hyperparameters through an auto-search in one dimension and a grid-search over the remaining
dimensions
}
