/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.util.List;
import java.util.Vector;
import org.af.jhlir.call.RErrorException;
import org.mutoss.gui.Design;
import org.mutoss.gui.RControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossDes {
    static final int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97};

    public static List<Design> getDesigns(int t, int p, int s1, int s2) {
        Design design;
        int[] signatureNr;
        Vector<Design> list = new Vector<Design>();
        String title = null;
        String reference = null;
        String signature = null;
        String result = null;
        if (p <= t) {
            String rName = "t(crossdes::allcombs(" + t + "," + p + "))";
            RControl.getR().evalVoid(".tmpDesign <- " + rName);
            signatureNr = RControl.getR().eval("Crossover:::getSignature(.tmpDesign)").asRInteger().getData();
            if (s1 <= signatureNr[1] && signatureNr[1] <= s2) {
                title = "Carryover balanced generalized Youden design (uniform on the columns)";
                reference = "Generated by package crossdes. Martin Oliver Sailer (2008). crossdes: Design and Randomization in Crossover Studies. R package version 1.0-9.\n\nPatterson, H.D. (1952): The construction of balanced designs for experiments involving sequences of treatments. Biometrika 39, 32-48.\n\nWakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308.";
                result = RControl.getR().eval("paste(capture.output(dput(.tmpDesign)), collapse=\"\")").asRChar().getData()[0];
                signature = RControl.getR().eval("Crossover:::getSignatureStr(.tmpDesign)").asRChar().getData()[0];
                design = new Design(title, null, reference, signature, t, signatureNr[1], p, result);
                list.add(design);
            }
        }
        if (!CrossDes.isPrimePower(t) || p <= t) {
            // empty if block
        }
        if (t >= 100 || !CrossDes.isPrimePower(t) || p <= t) {
            // empty if block
        }
        for (int s = s1; s <= s2; ++s) {
            if (p >= t || (t - 1) % (p - 1) != 0) continue;
            try {
                RControl.getR().evalVoid(".tmpDesign <- t( crossdes::balmin.RMD(trt=" + t + ", n=" + s + ", p=" + p + "))");
                signatureNr = RControl.getR().eval("Crossover:::getSignature(.tmpDesign)").asRInteger().getData();
                title = "Balanced Minimal Repeated Measurements Designs of Afsarinejad (1983)";
                reference = "Generated by package crossdes. Martin Oliver Sailer (2008). crossdes: Design and Randomization in Crossover Studies. R package version 1.0-9.\n\nAfsarinejad, K. (1983): Balanced repeated measurements designs. Biometrika 70, 199-204.Wakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308.";
                result = RControl.getR().eval("paste(capture.output(dput(.tmpDesign)), collapse=\"\")").asRChar().getData()[0];
                signature = RControl.getR().eval("Crossover:::getSignatureStr(.tmpDesign)").asRChar().getData()[0];
                design = new Design(title, null, reference, signature, t, signatureNr[1], p, result);
                list.add(design);
                continue;
            }
            catch (RErrorException e) {
                // empty catch block
            }
        }
        return list;
    }

    public static boolean isPrimePower(long t) {
        int[] arr$ = primes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long p = arr$[i$];
            long result = 0L;
            int n = 1;
            while (result < t) {
                result = Math.round(Math.pow(p, n));
                if (result == t) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

