% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_records.R
\name{map_records_interva4}
\alias{map_records_interva4}
\title{Map VA records to InterVA4.}
\usage{
map_records_interva4(records, csv_outfile = "")
}
\arguments{
\item{records}{A dataframe, obtained from reading an ODKBriefcase
export of records collected with the WHO questionnaire.}

\item{csv_outfile}{Path to a file to write transformed data to.
Defaults to empty string, in which case no file is written.}
}
\value{
A dataframe, with the VA records mapped to the variables required
  by InterVA4.
}
\description{
\code{map_records} transform data collected with the WHO VA instrument
  for coding with the InterVA4 algorithm.
}
\examples{
\dontrun{
record_f_name <- system.file('sample', 'who_va_output.csv', package = 'CrossVA')
records <- read.csv(record_f_name)
output_data <- map_records_interva4(records)
}
}
\references{
http://www.interva.net/
}

