\name{datfc}
\alias{datfc}
\docType{data}
\title{ Simulated Data, Mixed}
\description{This data is simulated. The covariates, X, and the treatment, T, are all generated by simulating from independent or  multivariate normal distributions and then some variables are dichotomized to get binary variables with a certain dependence structure. The code generating the data is \cr
\cr
\code{library(bindata)}\cr
\code{set.seed(9327529)}\cr
\code{n<-500}\cr
\code{x1 <- rnorm(n, mean = 0, sd = 1)}\cr  
\code{x2 <- rbinom(n, 1, prob = 0.5)}\cr
\code{x25 <- rmvbin(n, bincorr=cbind(c(1,0.7),c(0.7,1)), margprob=c(0.5,0.5))}\cr
\code{x2 <- x25[,1]}\cr                 
\code{Sigma <-  matrix(c(1,0.5,0.5,1),ncol=2)}\cr
\code{x34 <- mvrnorm(n, rep(0, 2), Sigma)}\cr
\code{x3 <- x34[,1]}\cr                
\code{x4 <- x34[,2]}\cr
\code{x5 <- x25[,2]}\cr  
\code{x6 <- rbinom(n, 1, prob = 0.5)}\cr                          
\code{x7<- rnorm(n, mean = 0, sd = 1)}\cr  
\code{x8 <- rbinom(n, 1, prob = 0.5)}\cr
\code{e0<-rnorm(n)}\cr                                    
\code{e1<-rnorm(n)}\cr 
\code{p <- 1/(1 + exp(3 - 1.2 * x1 - 3.7 * x2 - 1.5 * x3 - 0.3 * x4 - 0.3 * x5 - 1.9 * x8))}\cr
\code{T <- rbinom(n, 1, prob = p)}\cr         
\code{y0 <- 4 + 2 * x1 + 3 * x4 + 5 * x5 + 2 * x6 + e0}\cr
\code{y1 <- 2 + 2 * x1 + 3 * x4+ 5 * x5 + 2 * x6 + e1}\cr
\code{y <- y1 * T + y0 * (1 - T)}\cr
\code{datfc <- data.frame(x1, x2, x3, x4, x5, x6, x7, x8, y0, y1, y, T)}\cr
\code{datfc[, c(2, 5, 6, 8)] <- lapply(datfc[, c(2, 5, 6, 8)], factor)}\cr
\code{datfc[, 12] <- as.numeric(datfc[, 12])}
}
\usage{data(datfc)}
\format{
  A data frame with 500 observations on the following 12 variables.
  \describe{
    \item{\code{x1  }}{a numeric vector}
    \item{\code{x2  }}{a factor with two levels}
    \item{\code{x3  }}{a numeric vector}
    \item{\code{x4  }}{a numeric vector}
    \item{\code{x5  }}{a factor with two levels}
    \item{\code{x6  }}{a factor with two levels}
    \item{\code{x7  }}{a numeric vector}
    \item{\code{x8  }}{a factor with two levels}
    \item{\code{y0  }}{a numeric vector}
    \item{\code{y1  }}{a numeric vector}
    \item{\code{y   }}{a numeric vector}
    \item{\code{T }}{a numeric vector}
  }
}
