% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshapeWide.R
\name{reshapeWide}
\alias{reshapeWide}
\title{Reshape Grouped Data to Wide}
\usage{
reshapeWide(dataset = cs.in.dataset(), preds = cs.in.predictors(),
  resps = cs.in.responses(), groups = cs.in.groupvars(),
  scriptvars = cs.in.scriptvars(), return.results = FALSE, ...)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{preds}{[\code{character}]\cr
Character vector of predictor variables.}

\item{resps}{[\code{character}]\cr
Character vector of response variables.}

\item{groups}{[\code{character}]\cr
Character vector of group variables.}

\item{scriptvars}{[\code{list}]\cr
Named list of script variables set via the Cornerstone "Script Variables" menu.
For details see below.}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}

\item{...}{[ANY]\cr
Additional arguments to be passed to 
\code{\link[data.table:dcast.data.table]{dcast}}
. Please consider possible script variables (\code{scriptvars}) to prevent duplicates.}
}
\value{
Logical [\code{TRUE}] invisibly or, if \code{return.results = TRUE}, \code{\link{list}} of 
  resulting \code{\link{data.frame}} object:
  \item{reshapeWide}{Dataset with reshaped data.}
}
\description{
Reshaping grouped data via \code{\link[data.table:dcast.data.table]{dcast}} to 'wide' format with
  rows for each unique combination of group variables. The response are arranged in
  separate columns for each datum in predictors. If a combination of groups identifies
  multiple rows, the number of rows in a group is returned to CS for the whole dataset
  instead of the response variable value.
}
\details{
One script variables is summarized in \code{scriptvars} list:\cr
  \describe{
    \item{nodrop}{[\code{logical(1)}]\cr
      Drop missing combinations (\code{FALSE}) or include all (\code{TRUE}).
      Default is \code{FALSE}.}
  }
}
\examples{
# Reshape dataset to wide format:
reshapeWide(Indometh, "Subject", "time", "conc", list(nodrop = FALSE), return.results = TRUE)
}
