% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_simulation.R
\name{simulate_dropout2}
\alias{simulate_dropout2}
\title{Simulate dropout expression data}
\usage{
simulate_dropout2(counts, min.rate = 0, max.rate = 0.8)
}
\arguments{
\item{counts}{expression matrix where each row is a gene and each column is a sample.}

\item{min.rate}{the minimum dropout rate of all samples.}

\item{max.rate}{the maximum dropout rate of all samples.}
}
\value{
This function will return a list with the following components:
  \item{counts}{The modified expression matrix with the same dimension as input \code{counts}.}
  \item{original.counts}{The original input expression matrix.}
  \item{dropout}{The binary matrix indicating where the dropout events happen.}
}
\description{
Generate the expression data with desired dropout rate range
}
\details{
The dropout event is modelled by a logistic distribution such that the low expression genes have 
higher probability of dropout. The expression value of genes in a sample are randomly set to zero
with probabilities associated with their true expression values until the desired dropout rate
for that sample is meet.
}
\references{
Peter V. Kharchenko, Lev Silberstein, and David T. Scadden.
Bayesian approach to single-cell differential expression analysis.
Nature Methods, 11(7):740–742, 2014.
}
