% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootpcorSE_calc.R
\name{bootpcorSE_calc}
\alias{bootpcorSE_calc}
\title{Calculate bootstrap SE for the Fisher z-scores of partial correlations}
\usage{
bootpcorSE_calc(data, nboot = 50, cor_method, thresh_up = 0.999,
  thresh_down = 0.001, verbose = TRUE)
}
\arguments{
\item{data}{The samples by features data matrix.}

\item{nboot}{The number of bootstrap samples.}

\item{cor_method}{The method of correlation used. May be "pearson", "spearman" or "kendall"
depending on the type of correlation to be used by the user.}

\item{thresh_up}{The upward threshold for partial correlations}

\item{thresh_down}{The downward threshold for partial correlations.}

\item{verbose}{To print the status of Bootstrap runs}
}
\value{
Returns standard errors for fisher z-scores for the partial correlations.
}
\description{
computes the bootstrap SE of the Fisher z-scores of partial correlations for
             a fixed number of resamples
}
\keyword{adaptive}
\keyword{correlation}
\keyword{partial}
\keyword{shrinkage,}
