% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conan.R
\name{Conan}
\alias{Conan}
\title{Removes missing values (rows and column to obtain a large full matrix)}
\usage{
Conan(
  X = X,
  nbstep = Inf,
  std = FALSE,
  verbose = FALSE,
  coercing = NULL,
  Xout = TRUE
)
}
\arguments{
\item{X}{the dataset (matrix) with missing values}

\item{nbstep}{number of cutting steps (may remove several rows or columns at each step)}

\item{std}{(boolean) remove constant covariates}

\item{verbose}{(boolean) to print the result}

\item{coercing}{vector of the covariates to keep (names or index)}

\item{Xout}{(boolean) to export or not the reduced matrix (if not, indices are sufficient)}
}
\value{
\item{individus_restants}{Index of remaining individuals}
\item{variables_restantes}{Index of remaining variables}
\item{X}{If \code{Xout=TRUE}, the reduced dataset without missing values}
}
\description{
Removes missing values (rows and column alternatively) to obtain a large full matrix
}
\examples{
data <- mtcars
datamiss = Terminator(target = data, wrath = 0.05) # 5\% of missing values
datamiss
showdata(datamiss) # plot positions of the missing values
reduced = Conan(X = datamiss)
reduced
  
}
