% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matplot_zone.R
\name{matplot_zone}
\alias{matplot_zone}
\title{Matplot with curves comparison by background colors.}
\usage{
matplot_zone(x = x, y = y, col = 1:6, alpha = 0.2, what = which.min,
  ylim = NULL, xlim = NULL, type = "p", xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{x}{the abscisses}

\item{y}{matrix of the curves (columns)}

\item{col}{list of colors (like in matplot)}

\item{alpha}{parameter for transparency of the background}

\item{what}{a function to choose a winner. Takes y as an input and must return a vector of colors (can be positive integers) of size length(x)}

\item{ylim}{ranges of y axe}

\item{xlim}{ranges of x axe}

\item{type}{character string (length 1 vector) or vector of 1-character strings indicating the type of plot for each column of y. The first character of type defines the first plot, the second character the second, etc. Characters in type are cycled through; e.g., "pl" alternately plots points and lines.}

\item{xlab}{title for x axe}

\item{ylab}{title for y axe}

\item{...}{Other graphical parameters}
}
\description{
Plot the columns of one matrix against the columns of another, with conditionnal background for easier comparison of curves.
}
\examples{
    \dontrun{
require(CorReg)
n=15
x=1:n
y=cbind(c(rnorm(5,0,1),rnorm(5,1,1),rnorm(5,2,1)),
         c(rnorm(5,0,1),rnorm(5,1,1),rnorm(5,4,1)),
         c(rnorm(5,1,3),rnorm(5,1,2),rnorm(5,1,1)))
matplot_zone(x,y,type="l",what=which.max,main="Highest curve")
#background color follows color of the highest curve
matplot_zone(x,y,type="l",what=which.min,main="Lowest curve")
#background color follows color of the lowest curve

}
}

