% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_equal.R
\name{cf_equal}
\alias{cf_equal}
\title{Identify Fossils with equal min and max age}
\usage{
cf_equal(
  x,
  min_age = "min_ma",
  max_age = "max_ma",
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing fossil records with taxon names, ages, 
and geographic coordinates.}

\item{min_age}{character string. The column with the minimum age. Default
= \dQuote{min_ma}.}

\item{max_age}{character string. The column with the maximum age. Default
= \dQuote{max_ma}.}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
  containing the records considered correct by the test (\dQuote{clean}) or a
  logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test
  failed/potentially problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records with equal minimum and maximum age.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
details and tutorials.
}
\examples{

minages <- runif(n = 10, min = 0.1, max = 25)
x <- data.frame(species = letters[1:10], 
                min_ma = minages, 
                max_ma = minages + runif(n = 10, min = 0, max = 10))
x <- rbind(x, data.frame(species = "z", 
                min_ma = 5, 
                max_ma = 5))
                
cf_equal(x, value = "flagged")

}
\seealso{
Other fossils: 
\code{\link{cf_age}()},
\code{\link{cf_outl}()},
\code{\link{cf_range}()},
\code{\link{write_pyrate}()}
}
\concept{fossils}
\keyword{Fossils}
\keyword{Temporal}
\keyword{cleaning}
