% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicGoodValueConcept.R
\name{publicGoodValue}
\alias{publicGoodValue}
\alias{hollerValue}
\title{Compute (normalized) Public Good value}
\usage{
publicGoodValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Public Good value for specified nonnegative TU game
}
\description{
Calculates the (normalized) Public Good value for a specified nonnegative TU game.
Note that the normalized Public Good value is sometimes also referred to as Holler value 
in the literature. Our function implements the formula from Definition 5.4, p. 19, in the paper 
by Bertini and Stach from 2015.
}
\examples{
library(CoopGame)
v=c(0,0,0,0.7,11,0,15)
publicGoodValue(v)

}
\references{
Holler M.J. and Li X. (1995) "From public good index to public value. An axiomatic approach and generalization", Control and Cybernetics 24, pp. 257--270

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
