% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MajoritySingleVetoGame.R
\name{majoritySingleVetoGameVector}
\alias{majoritySingleVetoGameVector}
\title{Compute game vector for a weighted majority game with a single veto player}
\usage{
majoritySingleVetoGameVector(n, vetoPlayer)
}
\arguments{
\item{n}{represents the number of players}

\item{vetoPlayer}{represents the veto player}
}
\value{
Game Vector where each elements contains \code{1} if vetoPlayer is included 
in \code{S} and \code{S} is not a singleton coalition, \code{0} otherwise
}
\description{
\strong{Game vector for a weighted majority game with a single veto player:} \cr
For further information see \link{majoritySingleVetoGame}
}
\examples{
library(CoopGame)
majoritySingleVetoGameVector(n=3, vetoPlayer=1)


}
\references{
Jackson M.O. (2008)  \emph{Social and Economic Networks}, Princeton University Press, p. 415
}
\author{
Michael Maerz
}
