% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyQuasiBalancedness.R
\name{isQuasiBalancedGame}
\alias{isQuasiBalancedGame}
\title{Check if game is quasi-balanced}
\usage{
isQuasiBalancedGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is quasi-balanced, else \code{FALSE}.
}
\description{
Checks if a TU game is quasi-balanced. \cr
A TU game is quasi-balanced if \cr
a) the components of its minimal rights vector are 
less or equal than the components of its utopia payoff 
vector \cr
and \cr
b) the sum of the components of its minimal rights vector 
is less or equal the value of the grand coalition which 
in turn is less or equal than the sum of the components 
of its utopia payoff vector. \cr
Note that any balanced game is also quasi-balanced, 
but not vice versa. \cr
Note that the quasi-balanced games are those games with 
a non-empty core cover.
Note also that quasi-balancedness is sometimes in the 
literature also referred to as compromise-admissibility.
}
\examples{
library(CoopGame)
isQuasiBalancedGame(c(0,0,0,1,1,1,4))

\donttest{
#Example of a quasi-balanced game:
library(CoopGame)
v1=c(1,1,2,6,8,14,16)
isQuasiBalancedGame(v1)

#Example of a game which is not quasi-balanced:
library(CoopGame)
v2=c(1:7)
isQuasiBalancedGame(v2)
}

}
\references{
Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 31
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
