% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatelyConcept.R
\name{equalPropensityToDisrupt}
\alias{equalPropensityToDisrupt}
\title{Compute equal propensity to disrupt}
\usage{
equalPropensityToDisrupt(v, k = 1)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{k}{is the fixed coalition size to be considered when calculating the equal propensity to disrupt}
}
\value{
the value for the equal propensity to disrupt
}
\description{
equalPropensityToDisrupt calculates the 
equal propensity to disrupt for a TU game with n players 
and a specified coalition size k. See the original paper by 
Littlechild & Vaidya (1976) for the formula with general k and 
the paper by Staudacher & Anwander (2019) for the specific expression 
for k=1 and interpretations of the equal propensity to disrupt.
}
\examples{
library(CoopGame)
v=c(0,0,0,4,0,3,6)
equalPropensityToDisrupt(v, k=1)

}
\references{
Littlechild S.C. and Vaidya K.G. (1976) "The propensity to disrupt and the disruption nucleolus of a characteristic function game", Int. Journal of Game Theory 5(2), pp. 151--161

Staudacher J. and Anwander J. (2019) "Conditions for the uniqueness of the Gately point for cooperative games", arXiv preprint, arXiv:1901.01485, 10 pages.
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
