% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{drawPerCapitaNucleolus}
\alias{drawPerCapitaNucleolus}
\title{Draw per capita nucleolus for 3 or 4 players}
\usage{
drawPerCapitaNucleolus(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Per Capita Nucleolus")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawPerCapitaNucleolus draws the per capita nucleolus for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,3)
drawPerCapitaNucleolus(v) 

\donttest{
#Example from YOUNG 1985, p. 68
library(CoopGame)
v=c(0,0,0,0,9,10,12)
drawPerCapitaNucleolus(v)
}

}
\references{
Young H.P. (1985) "Monotonic Solutions of cooperative games", Int. Journal of Game Theory 14(2), pp. 65--72
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
