% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{pam_clust_from_adj_mat}
\alias{pam_clust_from_adj_mat}
\title{PAM (k-medoids) clustering from adjacency matrix}
\usage{
pam_clust_from_adj_mat(adj.mat, k = 2, alpha = 1, adj.conv = TRUE)
}
\arguments{
\item{adj.mat}{adjacency matrix}

\item{k}{number of clusters (default=2)}

\item{alpha}{soft threshold (considered if \code{adj.conv = TRUE}) (default=1)}

\item{adj.conv}{binary value to apply soft thresholding (default=TRUE)}
}
\value{
vector of clusters
}
\description{
PAM (k-medoids) clustering from adjacency matrix
}
\details{
apply PAM (k-medoids) clustering on the adjacency matrix
}
\examples{
Adj_mat = rbind(c(0.0,0.9,0.0),
                c(0.9,0.0,0.2),
                c(0.0,0.2,0.0))
pam_clust_from_adj_mat(Adj_mat)

}
