% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC_without_robScore_functions.R
\name{multi_kmeans_gen}
\alias{multi_kmeans_gen}
\title{Multiple K-means generation}
\usage{
multi_kmeans_gen(X, rep = 10, range.k = c(2, 5), method = "random")
}
\arguments{
\item{X}{input data Nsample x Nfeatures}

\item{rep}{number of repeats}

\item{range.k}{vector of minimum and maximum values for k \code{c(min, max)}}

\item{method}{method for the choice of k at each repeat \code{c("random", "silhouette")}}
}
\value{
matrix of clusterings Nsample x Nrepeat
}
\description{
Multiple K-means generation
}
\details{
At each repeat, k is selected randomly or based on the best silhouette width from a discrete uniform distribution between range.k[1] and range.k[2].
Then k-means clustering is applied and result is returned.
}
\examples{
X = gaussian_clusters()$X
Clusters = multi_kmeans_gen(X)

}
