% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMCons.R
\name{EMCons}
\alias{EMCons}
\title{Branch-and-bound algorithm to find consensus (median) ranking according to the Kemeny's axiomatic approach}
\usage{
EMCons(X, Wk = NULL, PS = TRUE)
}
\arguments{
\item{X}{A N by M data matrix, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. Alternatively X can contain the rankings observed only once. In this case the argument Wk must be used}

\item{Wk}{Optional: the frequency of each ranking in the data}

\item{PS}{If PS=TRUE, on the screen some information about how many branches are processed are displayed}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Consensus \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged TauX rank correlation coefficient\cr
Eltime\tab   \tab Elapsed time in seconds}
}
\description{
Branch-and-bound algorithm to find consensus ranking as definned by Emond and Mason (2002). If the number of objects to be ranked is large (greater than 15 or 20, specially if there are missing rankings), it can work for very long time.
}
\details{
If the objects to be ranked is large (>15-20) with some missing, it can take long time to find the solutions. If the searching space is limited to the space of full rankings (also incomplete rankings, but without ties), use the function BBFULL or the functions FASTcons and QuickCons with the option FULL=TRUE.
}
\examples{
data(Idea)
RevIdea=6-Idea 
# as 5 means "most associated", it is necessary compute the reverse ranking of 
# each rankings to have rank 1 = "most associated" and rank 5 = "least associated"
CR=EMCons(RevIdea)

}
\references{
Emond, E. J., and Mason, D. W. (2002). A new rank correlation coefficient with application to the consensus ranking problem. Journal of Multi-Criteria Decision Analysis, 11(1), 17-28.
}
\seealso{
\code{\link{FASTcons}} FAST algorithm algorithm.

\code{\link{QuickCons}} Quick algorithm.

\code{\link{BBFULL}} Branc-and-bound algorithm for full rankings.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Consensus}
\keyword{median}
\keyword{ranking}
