% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bCond.estimation.R
\name{bCond.estParamCopula}
\alias{bCond.estParamCopula}
\title{Estimation of the conditional parameters of a parametric conditional
copula with discrete conditioning events.}
\usage{
bCond.estParamCopula(U1, U2, family, partition)
}
\arguments{
\item{U1}{vector of \code{n} conditional pseudo-observations
of the first conditioned variable.}

\item{U2}{vector of \code{n} conditional pseudo-observations
of the second conditioned variable.}

\item{family}{the family of conditional copulas
used for each conditioning event \eqn{A_k}. If not of length \eqn{p},
it is recycled to match the number of events \eqn{p}.}

\item{partition}{matrix of size \code{n * p},
where \code{p} is the number of conditioning events that are considered.
partition[i,j] should be the indicator of whether the \code{i}-th observation
belongs or not to the \code{j}-th conditioning event}
}
\value{
a list of size \code{p} containing the \code{p} conditional copulas
}
\description{
By Sklar's theorem, any conditional distribution function
can be written as
\deqn{F_{1,2|A}(x_1, x_2) = c_{1,2|A}(F_{1|A}(x_1), F_{2,A}(x_2)),}
where \eqn{A} is an event and
\eqn{c_{1,2|A}} is a copula depending on the event \eqn{A}.
In this function, we assume that we have a partition \eqn{A_1,... A_p}
of the probability space, and that for each \eqn{k=1,...,p},
the conditional copula is parametric according to the following model
\deqn{c_{1,2|Ak} = c_{\theta(Ak)},}
for some parameter \eqn{\theta(Ak)} depending on the realized event \eqn{Ak}.
This function uses canonical maximum likelihood to estimate
\eqn{\theta(Ak)} and the corresponding copulas \eqn{c_{1,2|Ak}}.
}
\examples{
n = 800
Z = stats::runif(n = n)
CKT = 0.2 * as.numeric(Z <= 0.3) +
  0.5 * as.numeric(Z > 0.3 & Z <= 0.5) +
  - 0.8 * as.numeric(Z > 0.5)
simCopula = VineCopula::BiCopSim(N = n,
  par = VineCopula::BiCopTau2Par(CKT, family = 1), family = 1)
X1 = simCopula[,1]
X2 = simCopula[,2]
partition = cbind(Z <= 0.3, Z > 0.3 & Z <= 0.5, Z > 0.5)
condPseudoObs = bCond.pobs(X = cbind(X1, X2), partition = partition)

estimatedCondCopulas = bCond.estParamCopula(
  U1 = condPseudoObs[,1], U2 = condPseudoObs[,2],
  family = 1, partition = partition)
print(estimatedCondCopulas)
# Comparison with the true conditional parameters: 0.2, 0.5, -0.8.


}
\references{
Derumigny, A., & Fermanian, J. D. (2017).
About tests of the “simplifying” assumption for conditional copulas.
Dependence Modeling, 5(1), 154-197.
\doi{10.1515/demo-2017-0011}
}
\seealso{
\code{\link{bCond.pobs}} for the computation
of (conditional) pseudo-observations in this framework.

\code{\link{bCond.simpA.param}} for a test of the simplifying assumption
that all these conditional copulas are equal
(assuming they all belong to the same parametric family).
\code{\link{bCond.simpA.CKT}} for a test of the simplifying assumption
that all these conditional copulas are equal,
based on the equality of conditional Kendall's tau.
}
