% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Make_Risks_Weighted_Single}
\alias{Make_Risks_Weighted_Single}
\title{Utility function to calculate the risk with a weighting applied and no derivatives calculated
\code{Make_Risks_Weighted_Single} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas}
\usage{
Make_Risks_Weighted_Single(
  modelform,
  tform,
  Term_n,
  totalnum,
  fir,
  s_weights,
  T0,
  Te,
  R,
  Dose,
  nonDose,
  TTerm,
  nonDose_LIN,
  nonDose_PLIN,
  nonDose_LOGLIN,
  nthreads,
  debugging,
  KeepConstant,
  gmix_theta,
  gmix_term
)
}
\arguments{
\item{modelform}{string model identifier}

\item{tform}{subterm types}

\item{Term_n}{Term numbers}

\item{totalnum}{total number of parameters}

\item{fir}{st term number}

\item{s_weights}{vector of weights for every row}

\item{T0}{Term value for each subterm}

\item{Te}{temporary term storage matrix}

\item{R}{risk vector}

\item{Dose}{term matrix}

\item{nonDose}{term matrix}

\item{TTerm}{Total term matrix}

\item{nonDose_LIN}{Linear term matrix}

\item{nonDose_PLIN}{Product linear term matrix}

\item{nonDose_LOGLIN}{Loglinear term matrix}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}

\item{gmix_theta}{theta value for geometric-mixture model}

\item{gmix_term}{list of 0/1 to identify which terms to set as Relative Risk (0) or Excess Risk (1)}
}
\value{
Updates matrices in place: Risk, Risk ratios
}
\description{
Utility function to calculate the risk with a weighting applied and no derivatives calculated
\code{Make_Risks_Weighted_Single} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
}
