% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_rbedInfo.R
\name{gcdhRegion}
\alias{gcdhRegion}
\title{Run GCDH over a region}
\usage{
gcdhRegion(pl_gwas, n_shift = NULL, snp, window = 500, out = NULL,
  gwas_col_select = collenv$.linear_header_default, collapse_matrix = NULL,
  rm_shifted_files = TRUE, dist_threshold = 5e+05)
}
\arguments{
\item{pl_gwas}{PlGwasC object}

\item{n_shift}{integer. Maximum shift number.}

\item{snp}{character. SNP name}

\item{window}{numeric. All variants with physical position no more than half the specified kb distance (decimal permitted) from the named variant are loaded.}

\item{out}{character. Path to the regional bed file (without .bed extension).}

\item{gwas_col_select}{character. See \code{runGcdh}}

\item{collapse_matrix}{See \code{runGcdh}}

\item{rm_shifted_files}{See \code{runGcdh}}

\item{dist_threshold}{See \code{runGcdh}}
}
\value{
See \code{runGcdh}
}
\description{
A region around some SNP is extracted and GCDH analysis is conducted over that region.
}
\author{
Kaiyin Zhong, Fan Liu
}

