% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaPlot.R
\name{ctmaPlot}
\alias{ctmaPlot}
\title{ctmaPlot}
\usage{
ctmaPlot(
  ctmaFitObject = NULL,
  activeDirectory = NULL,
  saveFilePrefix = "ctmaPlot",
  activateRPB = FALSE,
  plotCrossEffects = TRUE,
  plotAutoEffects = TRUE,
  timeUnit = "timeUnit (not specified)",
  timeRange = c(),
  yLimitsForEffects = c(),
  mod.number = 1,
  mod.values = -2:2,
  aggregateLabel = "",
  xLabels = NULL,
  undoTimeScaling = TRUE,
  ...
)
}
\arguments{
\item{ctmaFitObject}{'CoTiMA' Fit object}

\item{activeDirectory}{defines another active directory than the one used in ctmaInitFit}

\item{saveFilePrefix}{Prefix used for saved plots}

\item{activateRPB}{set to TRUE to receive push messages with 'CoTiMA' notifications on your phone}

\item{plotCrossEffects}{logical}

\item{plotAutoEffects}{logical}

\item{timeUnit}{label for x-axis when plotting discrete time plots}

\item{timeRange}{vector describing the time range for x-axis as sequence from/to/stepSize (e.g., c(1, 144, 1))}

\item{yLimitsForEffects}{range for y-axis}

\item{mod.number}{moderator number that should be used for plots}

\item{mod.values}{moderator values that should be used for plots}

\item{aggregateLabel}{label to indicate aggregated discrete time effects}

\item{xLabels}{labes used for x-axis}

\item{undoTimeScaling}{if TRUE, the original time scale is used (timeScale argument possibly used in \code{\link{ctmaInit}} is undone )}

\item{...}{arguments passed through to plot()}
}
\value{
depending on the CoTiMA fit object supplied, generates funnel plots, forest plots, discrete time plots of
autoregressive and cross-lagged effects, plots of required samples sizes across a range of discrete time intervals
to achieve desired levels of statistical power, and post hoc power of primary studies. Plots are saved to disk.
}
\description{
Forest plot, funnel plots, plots of discrete time cross-lagged and autoregressive effect, and plots of required sample sizes
}
\examples{
\dontrun{
# cannot run without proper activeDirectory specified. Adapt!
CoTiMAFullFit_3$activeDirectory <- "/Users/tmp/" # adapt!
plot(ctmaFitList(CoTiMAInitFit_3, CoTiMAFullFit_3),
     timeUnit="Months", timeRange=c(1, 144, 1),
     plotAutoEffects=FALSE)
}

\dontrun{
# cannot run without proper activeDirectory specified. Adapt!
CoTiMABiG_D_BO$activeDirectory <- "/Users/tmp/" # adapt!
plot(CoTiMABiG_D_BO)
}

}
