% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalACF.R
\name{seasonalACF}
\alias{seasonalACF}
\title{Calculate seasonal ACF}
\usage{
seasonalACF(TS, season, lag.max = 50)
}
\arguments{
\item{TS}{time series}

\item{season}{name of the season}

\item{lag.max}{max lag for acf}
}
\description{
Calculate seasonal ACF
}
\examples{

data('precip')

\dontshow{
 precip <- precip[between(date, as.POSIXct('1990-1-01', format('\%Y-\%m-\%d'), tz = 'America/Regina'),
 as.POSIXct('1990-1-10', format('\%Y-\%m-\%d'), tz = 'America/Regina'))]
}
seasonalACF(precip, 'month')

}
\keyword{internal}
