% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/temporalSimu.R
\name{temporalSimu}
\alias{temporalSimu}
\title{Temporal data simulation}
\usage{
temporalSimu(seed = unclass(Sys.time()), groupSize, sdd, numGroups)
}
\arguments{
\item{seed}{to seed the simulation. Default is current system time.}

\item{groupSize}{the number of the temporal profiles to simulate from each template. The total number of profiles will be the number of templates used times the size of each group.}

\item{sdd}{the standard deviation to be used to generate randomness for each temporal profile.}

\item{numGroups}{number of templates to be used for generating data.}
}
\value{
a matrix containing simulated time-series dataset.
}
\description{
This function simulates time-series data using 14 pre-defined temporal profile templates. Type 'temporalSimu' to see the details of the templates.
}
\examples{
# simulate a time-series data with four distinctive profile groups and each group with
# a size of 500 phosphorylation sites

simulated.temporal <- temporalSimu(seed=1, groupSize=500, sdd=1, numGroups=4)
}

