% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/runClue.R
\name{runClue}
\alias{runClue}
\title{Run CLUster Evaluation}
\usage{
runClue(Tc, annotation, rep = 10, kRange, clustAlg = "cmeans",
  effectiveSize = c(5, 100), pvalueCutoff = 0.05, alpha = 0.5)
}
\arguments{
\item{Tc}{a numeric matrix to be clustered. The columns correspond to the time-course and the rows correspond to phosphorylation sites.}

\item{annotation}{a list with names correspond to kinases and elements correspond to substrates belong to each kinase.}

\item{rep}{number of times the clustering is to be applied. This is to account for variability in the clustering algorithm.}

\item{kRange}{the range of k to be tested for clustering.}

\item{clustAlg}{the clustering algorithm to be used. The default is cmeans clustering.}

\item{effectiveSize}{the size of annotation groups to be considered for calculating enrichment. Groups that are too small
or too large will be removed from calculating overall enrichment of the clustering.}

\item{pvalueCutoff}{a pvalue cutoff for determining which kinase-substrate groups to be included in calculating overall enrichment of the clustering.}

\item{alpha}{a penalty factor for penalizing large number of clusters.}
}
\value{
a clue output that contains the input parameters used for evaluation and the evaluation results. Use ls(x) to see details of output. 'x' be the output here.
}
\description{
Takes in a time-course matrix and test for enrichment of the clustering using cmeans or kmeans clustering algorithm with a reference annotation.
}
\examples{
# load the human ES phosphoprotoemics data (Rigbolt et al. Sci Signal. 4(164):rs3, 2011)
data(hES)
# load the PhosphoSitePlus annotations (Hornbeck et al. Nucleic Acids Res. 40:D261-70, 2012)
data(PhosphoSite)

# make a subset of hES dataset for demonstrating the example in a short time frame
ids <- c("CK2A1", "ERK1", "ERK2", "CDK7",
"p90RSK", "p70S6K", "PKACA", "CDK1", "DNAPK", "ATM", "CDK2")
hESs <- hES[rownames(hES) \%in\% unlist(PhosphoSite.human[ids]),]

# run CLUE with a repeat of 3 times and a range from 2 to 13
set.seed(2)
clueObj <- runClue(Tc=hESs, annotation=PhosphoSite.human, rep=2, kRange=13)

# visualize the evaluation outcome
Ms <- apply(clueObj$evlMat, 2, mean, na.rm=TRUE)
Ss <- apply(clueObj$evlMat, 2, sd, na.rm=TRUE)
library(Hmisc)
errbar(1:length(Ms), Ms, Ms+Ss, Ms-Ss, cex=1.2, type="b", xaxt="n", xlab="k", ylab="E")
axis(1, at=1:12, labels=paste("k=", 2:13, sep=""))

# generate the optimal clustering results
best <- clustOptimal(clueObj, rep=10, mfrow=c(3, 4))

# list enriched clusters
best$enrichList

# obtain the optimal clustering object (not run)
# best$clustObj
}

