% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_test.r
\name{lr_test}
\alias{lr_test}
\title{Likelihood ratio test for nested models}
\usage{
lr_test(data, null_model, alt_model)
}
\arguments{
\item{data}{A vector of class 'circular'}

\item{null_model}{character string indicating the null model to be used.
Must be one of c("M1", "M2A", "M2B", "M2C", "M3A", "M3B", "M4A", "M4B",
"M5A", "M5B").}

\item{alt_model}{character string indicating the alternative model to be used.
Must be one of c("M1", "M2A", "M2B", "M2C", "M3A", "M3B", "M4A", "M4B",
"M5A", "M5B").}
}
\value{
A list with elements:

$null_model: Vector with the model name and number of free parameters

$alt_model: Vector with the model name and number of free parameters

$lr: likelihood ratio test statistic 2 * (-log(L1) - -log(L2))

$df: degrees of freedom (difference in number of parameters between models)

$p_val: probability of rejecting null model in favor of alternative
model due to chance (e.g, if <0.05, data favors alternative model).
}
\description{
Statistically test nested models for the rejection of the null model
in favor of the alternative model.
}
\examples{
testdata = circular::rvonmises(100, mu = circular::circular(pi), kappa = 3)
lr_test(testdata, "M1", "M2A")
}
\keyword{chi-square}
\keyword{distribution}
\keyword{likelihood}
\keyword{ratio}
\keyword{test}
