% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{rPseudoWishart}
\alias{rPseudoWishart}
\title{Random Pseudo Wishart Distributed Matrices}
\usage{
rPseudoWishart(n, df, Sigma)
}
\arguments{
\item{n}{integer sample size.}

\item{df}{integer parameter, "degrees of freedom", should be less than the
dimension of \code{p}}

\item{Sigma}{positive definite \eqn{p \times p}{(p * p)} "scale" matrix, the
matrix parameter of the distribution.}
}
\value{
a numeric array, say \code{R}, of dimension \eqn{p \times p \times n}{p * p * n},
    where each \code{R[,,i]} is a realization of the pseudo Wishart distribution
    \eqn{W_p(Sigma, df)}.
}
\description{
Generate n random matrices, distributed according
    to the pseudo Wishart distribution with parameters \code{Sigma} and
    \code{df}, \eqn{W_p(\Sigma, df)}{W_p(Sigma, df)}, with sample size
    \code{df} less than the dimension \code{p}.

    Let \eqn{X_i}, \eqn{i = 1, 2, ..., df} be \code{df}
    observations of a multivariate normal distribution with mean 0 and
    covariance \code{Sigma}. Then \eqn{\sum X_i X_i'} is distributed as a pseudo
    Wishart \eqn{W_p(\Sigma, df)}{W_p(Sigma, df)}. Sometimes this is called a
    singular Wishart distribution, however, that can be confused with the case
    where \eqn{\Sigma}{Sigma} itself is singular. If cases with a singular
    \eqn{\Sigma}{Sigma} are desired, this function cannot provide them.
}
\examples{
set.seed(20181227)
A<-rPseudoWishart(1,4,5.0*diag(5))[,,1]
# A should be singular
eigen(A)$values

}
\references{
Diaz-Garcia, Jose A, Ramon Gutierrez Jaimez, and Kanti V Mardia. 1997.
“Wishart and Pseudo-Wishart Distributions and Some Applications to Shape Theory.”
Journal of Multivariate Analysis 63 (1): 73–87. \doi{10.1006/jmva.1997.1689}.

Uhlig, Harald. On Singular Wishart and Singular Multivariate Beta Distributions.
Ann. Statist. 22 (1994), no. 1, 395--405. \doi{10.1214/aos/1176325375}.
}
\seealso{
\code{\link{rWishart}}, \code{\link{rInvWishart}},
    and \code{\link{rGenInvWishart}}
}
