% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_gps.R
\name{estimate_gps}
\alias{estimate_gps}
\title{Estimate generalized propensity score (GPS) values}
\usage{
estimate_gps(
  w,
  c,
  gps_density = "normal",
  params = list(),
  sl_lib = c("m_xgboost"),
  nthread = 1,
  ...
)
}
\arguments{
\item{w}{A data frame of observed continuous exposure variable. Including
\code{id} and \code{w} columns.}

\item{c}{A data frame of observed covariates variable. Also includes \code{id}
column.}

\item{gps_density}{Model type which is used for estimating GPS value,
including \code{normal} (default) and \code{kernel}.}

\item{params}{Includes list of parameters that are used internally. Unrelated
parameters will be ignored.}

\item{sl_lib}{A vector of prediction algorithms.}

\item{nthread}{An integer value that represents the number threads to be used
in a shared memory system.}

\item{...}{Additional arguments passed to the model.}
}
\value{
The function returns a S3 object. Including the following:
\itemize{
\item \code{dataset }: \code{id}, \code{w}, \code{gps}
\item e_gps_pred
\item e_gps_std_pred
\item w_resid
\item gps_mx (min and max of gps)
\item w_mx (min and max of w).
\item used_params
}
}
\description{
Estimates GPS value for each observation using normal or kernel
approaches.
}
\note{
If \code{internal.use} is set to be FALSE, only original data set + GPS will
be returned.

The outcome variable is not used in estimating the GPS value. However, it is
used in compiling the data set with GPS values.
}
\examples{
m_d <- generate_syn_data(sample_size = 100)
data_with_gps <- estimate_gps(m_d[, c("id", "w")],
                              m_d[, c("id", "cf1", "cf2", "cf3",
                                      "cf4", "cf5", "cf6")],
                              gps_density = "normal",
                              params = list(xgb_max_depth = c(3,4,5),
                                       xgb_nrounds=c(10,20,30,40,50,60)),
                              nthread = 1,
                              sl_lib = c("m_xgboost")
                             )

}
