% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absolute_weighted_corr_fun.R
\name{absolute_weighted_corr_fun}
\alias{absolute_weighted_corr_fun}
\title{Check  Weighted Covariate Balance Using Absolute Approach}
\usage{
absolute_weighted_corr_fun(w, vw, c)
}
\arguments{
\item{w}{A vector of observed continuous exposure variable.}

\item{vw}{A vector of weights.}

\item{c}{A data.table of observed covariates variable.}
}
\value{
The function returns a list saved the measure related to covariate balance
\code{absolute_corr}: the absolute correlations for each pre-exposure
covairates;
\code{mean_absolute_corr}: the average absolute correlations for all
pre-exposure covairates.
}
\description{
Checks covariate balance based on absolute weighted correlations for
given data sets.
}
\examples{
set.seed(639)
n <- 100
mydata <- generate_syn_data(sample_size=100)
year <- sample(x=c("2001","2002","2003","2004","2005"),size = n,
 replace = TRUE)
region <- sample(x=c("North", "South", "East", "West"),size = n,
 replace = TRUE)
mydata$year <- as.factor(year)
mydata$region <- as.factor(region)
mydata$cf5 <- as.factor(mydata$cf5)
data.table::setDT(mydata)
cor_val <- absolute_weighted_corr_fun(mydata[,2],
                                      data.table::data.table(runif(n)),
                                      mydata[, 3:length(mydata)])
print(cor_val$mean_absolute_corr)

}
