% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration_simplex.R,
%   R/calibration_simplex.default.R
\name{calibration_simplex}
\alias{calibration_simplex}
\alias{CalSim}
\alias{calibration_simplex.default}
\title{Calibration Simplex}
\usage{
calibration_simplex(n, p_a, p_n, p_b, obs, percentagewise)

\method{calibration_simplex}{default}(n = 10, p_a = NULL, p_n = NULL,
  p_b = NULL, obs = NULL, percentagewise = FALSE)
}
\arguments{
\item{n}{A natural number.}

\item{p_a}{A vector containing the forecasted probabilities for the above-normal (3) category.}

\item{p_n}{A vector containing the forecasted probabilities for the near-normal (2) category.}

\item{p_b}{A vector containing the forecasted probabilities for the below-normal (1) category.}

\item{obs}{A vector containing the observed outcomes (Categories are encoded as 1 (below-normal), 2 (near-normal) and 3 (above-normal)).}

\item{percentagewise}{Logical, specifying whether probabilities are percentagewise (summing to 100) or not (summing to 1).}
}
\value{
Object of class \code{calibration_simplex}.
}
\description{
Generates an object of class \code{calibration_simplex} which can be used to assess the calibration
of ternary probability forecasts. The Calibration Simplex can be seen as generalization of the reliability diagram
for binary probability forecasts. For details on the interpretation of the calibration simplex cf. Wilks, 2013. Be
aware that some minor changes have been made compared to the calibration simplex as suggested by Wilks, 2013 (cf. note below).
}
\details{
Only two of the three forecast probability vectors (\code{p_a}, \code{p_b} and \code{p_n}) need to be specified.
}
\note{
In contrast to the calibration simplex proposed by Daniel S. Wilks, 2013, the simplex has been
mirrored at the diagonal through the left bottom hexagon. The miscalibration error is by default calculated
precisely (in each bin as the difference of the relative frequencies of each class and the
average forecast probabilities) instead of approximately (using Wilks original formula).
Approximate errors can be used by setting \code{true_error = FALSE} when using \code{\link{plot.calibration_simplex}}.
}
\examples{
#install.packages("scoring") #if this package is not installed already
data("WeatherProbs", package = "scoring")

#Calibration Simplex for Temprature Forecasts
cst = calibration_simplex(p_a = WeatherProbs$tabv,
                          p_b = WeatherProbs$tblw,
                          obs=WeatherProbs$tcat)
plot(cst)
plot(cst,error_scale=1)

#Calibration Simplex for Precipitation Forecasts
csp = calibration_simplex(n=19,
                          p_a = WeatherProbs$pabv,
                          p_b = WeatherProbs$pblw,
                          obs=WeatherProbs$pcat)
plot(csp)
plot(csp,error_scale=1)

#Both forecasts are very(!) underconfident. This seems like an unrealistic example!

}
\references{
Daniel S. Wilks, 2013, The Calibration Simplex: A Generalization of the Reliability Diagram for Three-Category Probability Forecasts, \emph{Weather and Forecasting}, \strong{28}, 1210-1218
}
\seealso{
\code{\link{plot.calibration_simplex}}
}
