% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{lambda_max}
\alias{lambda_max}
\title{Maximum Eigenvalue}
\usage{
lambda_max(A)
}
\arguments{
\item{A}{An \linkS4class{Expression} or matrix.}
}
\value{
An \linkS4class{Expression} representing the maximum eigenvalue of the input.
}
\description{
The maximum eigenvalue of a matrix, \eqn{\lambda_{\max}(A)}.
}
\examples{
A <- Variable(2,2)
prob <- Problem(Minimize(lambda_max(A)), list(A >= 2))
result <- solve(prob)
result$value
result$getValue(A)

obj <- Maximize(A[2,1] - A[1,2])
prob <- Problem(obj, list(lambda_max(A) <= 100, A[1,1] == 2, A[2,2] == 2, A[2,1] == 2))
result <- solve(prob)
result$value
result$getValue(A)
}
