% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{norm_nuc}
\alias{norm_nuc}
\title{Nuclear Norm}
\usage{
norm_nuc(A)
}
\arguments{
\item{A}{An \linkS4class{Expression} or matrix.}
}
\value{
An \linkS4class{Expression} representing the nuclear norm of the input.
}
\description{
The nuclear norm, i.e. sum of the singular values of a matrix.
}
\examples{
C <- Variable(3,3)
val <- cbind(3:5, 6:8, 9:11)
prob <- Problem(Minimize(norm_nuc(C)), list(C == val))
result <- solve(prob)
result$value
}
