% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex2real.R
\docType{class}
\name{Complex2Real-class}
\alias{Complex2Real-class}
\alias{Complex2Real}
\alias{accepts,Complex2Real,Problem-method}
\alias{perform,Complex2Real,Problem-method}
\alias{invert,Complex2Real,Solution,InverseData-method}
\title{Lifts complex numbers to a real representation.}
\usage{
\S4method{accepts}{Complex2Real,Problem}(object, problem)

\S4method{perform}{Complex2Real,Problem}(object, problem)

\S4method{invert}{Complex2Real,Solution,InverseData}(object, solution, inverse_data)
}
\arguments{
\item{object}{A \linkS4class{Complex2Real} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{solution}{A \linkS4class{Solution} object to invert.}

\item{inverse_data}{A \linkS4class{InverseData} object containing data necessary for the inversion.}
}
\description{
This reduction takes in a complex problem and returns
an equivalent real problem.
}
\section{Methods (by generic)}{
\itemize{
\item \code{accepts(object = Complex2Real, problem = Problem)}: Checks whether or not the problem involves any complex numbers.

\item \code{perform(object = Complex2Real, problem = Problem)}: Converts a Complex problem into a Real one.

\item \code{invert(object = Complex2Real, solution = Solution, inverse_data = InverseData)}: Returns a solution to the original problem given the inverse data.

}}
