% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/affine.R
\docType{class}
\name{[,Expression,index,missing,ANY-method}
\alias{[,Expression,index,missing,ANY-method}
\alias{[,Expression,missing,index,ANY-method}
\alias{[,Expression,index,index,ANY-method}
\alias{[,Expression,matrix,index,ANY-method}
\alias{[,Expression,index,matrix,ANY-method}
\alias{[,Expression,matrix,matrix,ANY-method}
\alias{[,Expression,matrix,missing,ANY-method}
\alias{SpecialIndex-class}
\alias{.SpecialIndex}
\alias{SpecialIndex}
\alias{name,SpecialIndex-method}
\alias{is_atom_log_log_convex,SpecialIndex-method}
\alias{is_atom_log_log_concave,SpecialIndex-method}
\alias{get_data,SpecialIndex-method}
\alias{.grad,SpecialIndex-method}
\title{The SpecialIndex class.}
\usage{
\S4method{[}{Expression,index,missing,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,missing,index,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,index,index,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,matrix,index,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,index,matrix,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,matrix,matrix,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,matrix,missing,ANY}(x, i, j, ..., drop = TRUE)

SpecialIndex(expr, key)

\S4method{name}{SpecialIndex}(x)

\S4method{is_atom_log_log_convex}{SpecialIndex}(object)

\S4method{is_atom_log_log_concave}{SpecialIndex}(object)

\S4method{get_data}{SpecialIndex}(object)

\S4method{.grad}{SpecialIndex}(object)
}
\arguments{
\item{x, object}{An \linkS4class{Index} object.}

\item{i, j}{The row and column indices of the slice.}

\item{...}{(Unimplemented) Optional arguments.}

\item{drop}{(Unimplemented) A logical value indicating whether the result should be coerced to the lowest possible dimension.}

\item{expr}{An \linkS4class{Expression} representing a vector or matrix.}

\item{key}{A list containing the start index, end index, and step size of the slice.}
}
\description{
This class represents indexing using logical indexing or a list of indices into a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{name(SpecialIndex)}: Returns the index in string form.

\item \code{is_atom_log_log_convex(SpecialIndex)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(SpecialIndex)}: Is the atom log-log concave?

\item \code{get_data(SpecialIndex)}: A list containing \code{key}.

\item \code{.grad(SpecialIndex)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression} representing a vector or matrix.}

\item{\code{key}}{A list containing the start index, end index, and step size of the slice.}
}}

