% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\docType{class}
\name{Bool-class}
\alias{Bool-class}
\alias{.Bool}
\alias{Bool}
\alias{as.character,Bool-method}
\alias{canonicalize,Bool-method}
\alias{is_positive,Bool-method}
\alias{is_negative,Bool-method}
\title{The Bool class.}
\usage{
Bool(rows = 1, cols = 1, name = NA_character_)

\S4method{as.character}{Bool}(x)

\S4method{canonicalize}{Bool}(object)

\S4method{is_positive}{Bool}(object)

\S4method{is_negative}{Bool}(object)
}
\arguments{
\item{rows}{The number of rows in the variable.}

\item{cols}{The number of columns in the variable.}

\item{name}{(Optional) A character string representing the name of the variable.}

\item{x, object}{A \linkS4class{Bool} object.}
}
\description{
This class represents a boolean variable.
}
\section{Methods (by generic)}{
\itemize{
\item \code{canonicalize}: Enforce that the variable be boolean.

\item \code{is_positive}: A boolean variable is always positive or zero.

\item \code{is_negative}: A boolean variable is never negative.
}}

\section{Slots}{

\describe{
\item{\code{id}}{(Internal) A unique identification number used internally.}

\item{\code{rows}}{The number of rows in the variable.}

\item{\code{cols}}{The number of columns in the variable.}

\item{\code{name}}{(Optional) A character string representing the name of the variable.}

\item{\code{primal_value}}{(Internal) The primal value of the variable stored internally.}
}}

\examples{
x <- Bool(3, name = "indicator") ## Boolean 3-vector
y <- Bool(3, 3) ## Matrix boolean
name(x)
as.character(x)
canonicalize(y)
is_positive(x)
is_negative(y)
}
