% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Huber-class}
\alias{Huber-class}
\alias{.Huber}
\alias{Huber}
\alias{validate_args,Huber-method}
\alias{to_numeric,Huber-method}
\alias{sign_from_args,Huber-method}
\alias{is_atom_convex,Huber-method}
\alias{is_atom_concave,Huber-method}
\alias{is_incr,Huber-method}
\alias{is_decr,Huber-method}
\alias{get_data,Huber-method}
\alias{graph_implementation,Huber-method}
\title{The Huber class.}
\usage{
Huber(x, M = 1)

\S4method{validate_args}{Huber}(object)

\S4method{to_numeric}{Huber}(object, values)

\S4method{sign_from_args}{Huber}(object)

\S4method{is_atom_convex}{Huber}(object)

\S4method{is_atom_concave}{Huber}(object)

\S4method{is_incr}{Huber}(object, idx)

\S4method{is_decr}{Huber}(object, idx)

\S4method{get_data}{Huber}(object)

\S4method{graph_implementation}{Huber}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} object.}

\item{M}{A positive scalar value representing the threshold. Defaults to 1.}

\item{object}{A \linkS4class{Huber} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise Huber function, \eqn{Huber(x, M) = }
\itemize{
  \item{\eqn{2M|x|-M^2}}{for \eqn{|x| \geq |M|}}
   \item{\eqn{|x|^2}}{for \eqn{|x| \leq |M|.}}
 }
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check that \code{M} is a non-negative constant.

\item \code{to_numeric}: The Huber function evaluted elementwise on the input value.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: A logical value indicating whether the atom is weakly increasing.

\item \code{is_decr}: A logical value indicating whether the atom is weakly decreasing.

\item \code{get_data}: A list containing the parameter \code{M}.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric constant.}

\item{\code{M}}{A positive scalar value representing the threshold. Defaults to 1.}
}}

