% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\docType{class}
\name{SizeMetrics-class}
\alias{SizeMetrics-class}
\alias{.SizeMetrics}
\alias{SizeMetrics}
\alias{SizeMetrics}
\title{The SizeMetrics class.}
\usage{
SizeMetrics(problem)
}
\arguments{
\item{problem}{A \linkS4class{Problem} object.}
}
\description{
This class contains various metrics regarding the problem size.
}
\section{Slots}{

\describe{
\item{\code{num_scalar_variables}}{The number of scalar variables in the problem.}

\item{\code{num_scalar_data}}{The number of constants used across all matrices and vectors in the problem. Some constants are not apparent when the problem is constructed. For example, the \code{sum_squares} expression is a wrapper for a \code{quad_over_lin} expression with a constant \code{1} in the denominator.}

\item{\code{num_scalar_eq_constr}}{The number of scalar equality constraints in the problem.}

\item{\code{num_scalar_leq_constr}}{The number of scalar inequality constraints in the problem.}

\item{\code{max_data_dimension}}{The longest dimension of any data block constraint or parameter.}

\item{\code{max_big_small_squared}}{The maximum value of (big)(small)^2 over all data blocks of the problem, where (big) is the larger dimension and (small) is the smaller dimension for each data block.}
}}

