% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/probihg.R
\name{probihg}
\alias{probihg}
\title{Probability distribution of an IHG model}
\usage{
probihg(m,theta)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{theta}{Preference parameter}
}
\value{
The vector of the probability distribution of an IHG model.
}
\description{
Compute the probability distribution of an IHG model (Inverse Hypergeometric) without covariates.
}
\examples{
m<-10
theta<-0.30
pr<-probihg(m,theta)
plot(1:m,pr,type="h",xlab="Ordinal categories")
points(1:m,pr,pch=19)
}
\references{
D'Elia A. (2003). Modelling ranks using the inverse hypergeometric distribution,
\emph{Statistical Modelling: an International Journal}, \bold{3}, 65--78
}
\keyword{distribution}

