% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubecov.R
\name{cubecov}
\alias{cubecov}
\title{Main function for CUBE models with covariates}
\usage{
cubecov(m, ordinal, Y, W, Z, starting, maxiter, toler)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates for explaining the uncertainty component}

\item{W}{Matrix of selected covariates for explaining the feeling component}

\item{Z}{Matrix of selected covariates for explaining the overdispersion component}

\item{starting}{Vector of initial parameters estimates to start the optimization algorithm 
(it has length NCOL(Y) + NCOL(W) + NCOL(Z) + 3 to account for intercept terms 
for all the three components}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}
}
\value{
An object of the class "CUBE"
}
\description{
Function to estimate and validate a CUBE model with 
explicative covariates for all the three parameters.
}
\references{
Piccolo, D. (2014). Inferential issues on CUBE models with covariates,
 \emph{Communications in Statistics - Theory and Methods}, \bold{44}, 
 DOI: 10.1080/03610926.2013.821487
}
\keyword{internal}
