% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcovcub0q.R
\name{varcovcub0q}
\alias{varcovcub0q}
\title{Variance-covariance matrix of CUB models with covariates for the feeling component}
\usage{
varcovcub0q(m, ordinal, W, pai, gama)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of covariates for explaining the feeling component}

\item{pai}{Uncertainty parameter}

\item{gama}{Vector of parameters for the feeling component, whose length is 
NCOL(W)+1 to include an intercept term in the model (first entry of gama)}
}
\description{
Compute the variance-covariance matrix of parameter estimates of a CUB model
 with covariates for the feeling component.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not, 
it returns a warning message and produces a matrix with NA entries.
}
\examples{
data(univer)
m<-7
ordinal<-univer[,9]
pai<-0.86
gama<-c(-1.94, -0.17)
W<-univer[,4]           
varmat<-varcovcub0q(m, ordinal, W, pai, gama)
}
\references{
Piccolo D.(2006), Observed Information Matrix for MUB Models. \emph{Quaderni di Statistica},
 \bold{8}, 33--78,
}
\keyword{internal}

