% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inibest.R
\name{inibest}
\alias{inibest}
\title{Preliminary estimators for CUB models without covariates}
\usage{
inibest(m,freq)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{freq}{Vector of the absolute frequencies of given ordinal responses}
}
\value{
A vector \eqn{(\pi,\xi)} of the initial parameter estimates for a CUB model without covariates,
 given the absolute frequency distribution of ordinal responses
}
\description{
Compute preliminary parameter estimates of a CUB model without covariates for given ordinal
 responses. These preliminary estimators are used within the package code to start the E-M algorithm.
}
\examples{
m<-9
freq<-c(10,24,28,36,50,43,23,12,5)
estim<-inibest(m,freq) 
pai<-estim[1]
csi<-estim[2]
}
\seealso{
\code{\link{inibestgama}}
Iannario M. (2009). A comparison of preliminary estimators in a class of ordinal data models, 
\emph{Statistica & Applicazioni}, \bold{VII}, 25--44 \cr
 Iannario M. (2012). Preliminary estimators for a mixture model of ordinal data, 
 \emph{Advances in Data Analysis and Classification}, \bold{6}, 163--184
}
\keyword{htest}
\keyword{utilities}

