% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubforsim.R
\name{cubforsim}
\alias{cubforsim}
\title{Simulation routine for CUB models without covariates}
\usage{
cubforsim(m, ordinal, maxiter = 500, toler = 1e-06)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm (defaul: maxiter = 500)}

\item{toler}{Fixed error tolerance for final estimates (default: toler = 1e-6)}
}
\value{
An object of the class "CUB", with null output for $BIC since the routine is only for simulation purposes
}
\description{
Fit CUB models without covariates to given ordinal data. It is useful for simulation experiments since it performs the same
steps as \code{\link{CUB}} function of the package, but with no printed output.
}
\examples{
data(relgoods)
m<-10
ordinal<-na.omit(relgoods[,37])
simul<-cubforsim(m,ordinal,maxiter=500,toler=1e-6)
simul$estimates      # Estimated parameters vector (pai,csi)
###############
data(univer)
m<-7
ordinal<-univer[,12]
simul<-cubforsim(m,ordinal)
param<-simul$estimates   # Estimated parameters vector (pai,csi)
###############
m<-9; n<-500
pai<-0.7
csi<-0.4
ordinal<-simcub(n,m,pai,csi)
simul<-cubforsim(m,ordinal)
param<-simul$estimates
maxlik<-simul$loglik
niter<-simul$niter
varmat<-simul$varmat 
}
\seealso{
\code{\link{CUB}}, \code{\link{loglikCUB}}
}
\keyword{htest}

