% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{acf.ctre}
\alias{acf.ctre}
\title{Autocorrelation function}
\usage{
\method{acf}{ctre}(x, OCTRE = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{\link[CTRE]{ctre}}}

\item{OCTRE}{If FALSE (default), each magnitude is matched with its preceding
interarrival time. If TRUE, each magnitude is matched with its
succeeding interarrival time.}

\item{...}{Additional arguments passed to \code{\link[stats]{acf}}}
}
\description{
Calculates and plots the autocorrelation function for the bivariate
time series of interarrival times and magnitudes.
}
\examples{
  library(magrittr)
  flares \%>\% ctre() \%>\% thin(k=150) \%>\% acf()
}
