% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeriodAccumulation.R
\name{CST_PeriodAccumulation}
\alias{CST_PeriodAccumulation}
\title{Period Accumulation on 's2dv_cube' objects}
\usage{
CST_PeriodAccumulation(
  data,
  start = NULL,
  end = NULL,
  time_dim = "ftime",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{An 's2dv_cube' object as provided function \code{CST_Load} in
package CSTools.}

\item{start}{An optional parameter to defined the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the dimension to 
compute the indicator. By default, it is set to 'ftime'. More than one 
dimension name matching the dimensions provided in the object 
\code{data$data} can be specified.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A 's2dv_cube' object containing the indicator in the element
\code{data}.
}
\description{
Period Accumulation computes the sum (accumulation) of a given variable in a 
period. Providing precipitation data, two agriculture indices can be obtained 
by using this function:
\itemize{
 \item\code{SprR}{Spring Total Precipitation: The total precipitation from 
                  April 21th to June 21st}
 \item\code{HarR}{Harvest Total Precipitation: The total precipitation from 
                  August 21st to October 21st}
}
}
\examples{
exp <- NULL
exp$data <- array(rnorm(216)*200, dim = c(dataset = 1, member = 2, sdate = 3, 
                 ftime = 9, lat = 2, lon = 2))
class(exp) <- 's2dv_cube'
TP <- CST_PeriodAccumulation(exp)
exp$data <- array(rnorm(5 * 3 * 214 * 2),
                   c(memb = 5, sdate = 3, ftime = 214, lon = 2)) 
exp$attrs$Dates <- c(seq(as.Date("01-05-2000", format = "\%d-\%m-\%Y"), 
                        as.Date("30-11-2000", format = "\%d-\%m-\%Y"), by = 'day'),
                    seq(as.Date("01-05-2001", format = "\%d-\%m-\%Y"), 
                        as.Date("30-11-2001", format = "\%d-\%m-\%Y"), by = 'day'),
                    seq(as.Date("01-05-2002", format = "\%d-\%m-\%Y"), 
                        as.Date("30-11-2002", format = "\%d-\%m-\%Y"), by = 'day'))
SprR <- CST_PeriodAccumulation(exp, start = list(21, 4), end = list(21, 6))
dim(SprR$data)
head(SprR$attrs$Dates)
HarR <- CST_PeriodAccumulation(exp, start = list(21, 8), end = list(21, 10))
dim(HarR$data)
head(HarR$attrs$Dates)

}
