% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_flow_raster_qa.R
\name{ch_flow_raster_qa}
\alias{ch_flow_raster_qa}
\title{Raster plot of daily streamflows with WSC quality flags}
\usage{
ch_flow_raster_qa(DF, metadata = NULL)
}
\arguments{
\item{DF}{dataframe of daily streamflow read by ch_read_ECDE_flows}

\item{metadata}{dataframe of metadata or defaults to "HYDAT_list"}
}
\value{
Produces a raster plot: years against day of year, showing the data flags:
 \item{A}{(Partial)  in green}
 \item{B}{(Backwater) in cyan}
 \item{D}{(Dry) in yellow}
 \item{E}{(Estimated) in red}

Returns \code{TRUE} if executed properly; a standard R graphic is created.
}
\description{
Raster plot with WSC quality flags. 
This produces a plot showing the flow data in grayscale 
overlain by the Water Survey of Canada quality flags.  Colours are consistent with 
ECDataExplorer. Raster layout lets the use see the flags in a different context than in 
a hydrograph.
}
\examples{
data(HYDAT_list)
data(CAN05AA008)
qaplot <- ch_flow_raster_qa(CAN05AA008)

}
\seealso{
\code{\link{ch_read_ECDE_flows}}

\code{\link{ch_flow_raster}}
}
\author{
Paul Whitfield
}
