% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_rfa_julianplot.R
\name{ch_rfa_julianplot}
\alias{ch_rfa_julianplot}
\title{Circular plotting by day of year}
\usage{
ch_rfa_julianplot(
  rose.col = "gray40",
  rose.lwd = 1.5,
  rose.cex = 1.5,
  rose.radius = seq(0.25, 1, 0.25),
  ...
)
}
\arguments{
\item{rose.col, rose.lwd, rose.cex}{Properties of the polar axes.}

\item{rose.radius}{Vector of the position of the circular axis.}

\item{...}{Other parameter passed to \link{points}.}
}
\value{
Returns a empty rose plot by day of year
}
\description{
Create axis for plotting circular statistics in a unitary circle.
}
\examples{

data(flowAtlantic)

ss <- ch_rfa_seasonstat(date ~ id, flowAtlantic$ams)

ch_rfa_julianplot()
points(y ~ x, ss, pch = 16, col = cut(ss[,'radius'], c(0,.5,.75,1)))

}
\seealso{
\link{ch_rfa_seasonstat}.
}
\author{
Martin Durocher
}
